/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.bean.properties;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.install.commons.bean.ArrayDefinition;
import oracle.install.commons.bean.BeanDefinition;
import oracle.install.commons.bean.BeanStoreErrorCode;
import oracle.install.commons.bean.BeanStoreException;
import oracle.install.commons.bean.BeanStoreReader;
import oracle.install.commons.bean.ListDefinition;
import oracle.install.commons.bean.MapDefinition;
import oracle.install.commons.bean.PropertyDefinition;
import oracle.install.commons.bean.TypeTranslator;
import oracle.install.commons.bean.properties.PropertiesBeanStore;

public class PropertiesBeanStoreReader
extends BeanStoreReader<PropertiesBeanStore> {
    private static final Logger logger = Logger.getLogger(PropertiesBeanStoreReader.class.getName());
    private PropertiesBeanStore beanStore;

    @Override
    public PropertiesBeanStore getBeanStore() {
        return this.beanStore;
    }

    @Override
    protected Object readBean(BeanDefinition beanDefinition, Object bean) throws BeanStoreException {
        logger.info("Loading beans from Properties Bean Store. [BeanStoreName:" + this.beanStore.getBeanStoreName() + "]");
        return this._readBean(beanDefinition, null, bean);
    }

    private Object _readBean(PropertyDefinition propertyDefinition, String value, Object bean) throws BeanStoreException {
        Object returnValue = bean;
        String propertyName = propertyDefinition.getName();
        if (!this.getBeanStore().isCaseSensitive()) {
            propertyName = propertyName.toLowerCase();
        }
        Properties properties = this.getBeanStore().getProperties();
        if (propertyDefinition instanceof BeanDefinition) {
            BeanDefinition beanDefinition = (BeanDefinition)propertyDefinition;
            List<PropertyDefinition> memberDefinitions = beanDefinition.getMemberDefinitions();
            returnValue = bean == null ? beanDefinition.newInstance() : bean;
            for (PropertyDefinition memberDefinition : memberDefinitions) {
                Object propBean = memberDefinition.getValue(returnValue);
                try {
                    Object memberValue = this._readBean(memberDefinition, value, propBean);
                    if (memberValue == null) continue;
                    memberDefinition.setValue(returnValue, memberValue);
                    logger.info("Setting value for the property:" + memberDefinition.getName() + " in the bean:" + propertyName);
                }
                catch (BeanStoreException e) {
                    logger.fine(e.getMessage());
                }
            }
        } else {
            String string = value = value == null ? properties.getProperty(propertyName) : value;
            if (value != null) {
                if (propertyDefinition instanceof ListDefinition) {
                    String[] items;
                    ListDefinition listDefinition = (ListDefinition)propertyDefinition;
                    returnValue = null;
                    if (value.matches("[{].*[}]")) {
                        value = value.substring(1, value.length() - 1);
                    }
                    if ((items = value.split(",")).length > 0) {
                        PropertyDefinition entryDefinition = listDefinition.getEntryDefinition();
                        List list = listDefinition.newInstance();
                        returnValue = list;
                        for (String item : items) {
                            Object itemValue = this._readBean(entryDefinition, item, null);
                            list.add(itemValue);
                        }
                        logger.fine("Created List object of size:" + items.length + " for the property:" + propertyName);
                    }
                } else if (!(propertyDefinition instanceof MapDefinition)) {
                    if (propertyDefinition instanceof ArrayDefinition) {
                        String[] items;
                        ArrayDefinition arrayDefinition = (ArrayDefinition)propertyDefinition;
                        returnValue = null;
                        if (value.matches("[{].*[}]")) {
                            value = value.substring(1, value.length() - 1);
                        }
                        if ((items = value.split(",")).length > 0) {
                            PropertyDefinition entryDefinition = arrayDefinition.getEntryDefinition();
                            int n = items.length;
                            returnValue = Array.newInstance(entryDefinition.getBaseType(), n);
                            for (int i = 0; i < n; ++i) {
                                String item = items[i];
                                Object itemValue = this._readBean(entryDefinition, item, null);
                                Array.set(returnValue, i, itemValue);
                            }
                            logger.fine("Created Array object of size:" + n + " for the property:" + propertyName);
                        }
                    } else {
                        returnValue = null;
                        try {
                            returnValue = TypeTranslator.translate(value, propertyDefinition.getBaseType());
                        }
                        catch (IllegalArgumentException e) {
                            logger.info("IllegalArgumentException accurred while converting " + value + " to type:" + propertyDefinition.getBaseType());
                            logger.info(e.getMessage());
                        }
                    }
                }
            } else if (!properties.containsKey(propertyName)) {
                throw new BeanStoreException(BeanStoreErrorCode.UNSPECIFIED_PROPERTY, propertyName);
            }
        }
        return returnValue;
    }

    @Override
    public void open(PropertiesBeanStore beanStore) throws BeanStoreException {
        this.beanStore = beanStore;
    }

    @Override
    public void close() throws BeanStoreException {
        this.beanStore = null;
    }
}

